import without from 'lodash/without';
import concat from 'lodash/concat';

import { handleActions } from 'redux-actions';

import {
    ActionTypes, IChooseForFreeze, IChooseForUnfreeze,
    IFreezeState,
    IFreezeSuccess, IUnfreezeSuccess
} from './types';

const initialState: IFreezeState = {
    examsForFreeze: [],
    examsForUnfreeze: [],
    availableForFreezeExams: [],
    frozenExams: []
};

function freeze(state: IFreezeState): IFreezeState {

    return {
        ...state,
        lastAttemptFinish: null,
        isUnfrozenSuccess: false
    };
}

function freezeSuccess(state: IFreezeState, action: IFreezeSuccess): IFreezeState {
    const { exams, lastAttemptFinish } = action.payload;
    const availableForFreezeExams = without(state.availableForFreezeExams, ...exams);
    const frozenExams = concat(exams, state.frozenExams);

    return {
        ...state,
        isUnfrozenSuccess: false,
        lastAttemptFinish,
        availableForFreezeExams,
        frozenExams,
        isError: false,
        examsForFreeze: []
    };
}

function unfreeze(state: IFreezeState): IFreezeState {
    return {
        ...state
    };
}

function unfreezeSuccess(state: IFreezeState, action: IUnfreezeSuccess): IFreezeState {
    const { exams } = action.payload;
    const frozenExams = without(state.frozenExams, ...exams);
    const availableForFreezeExams = concat(exams, state.availableForFreezeExams);

    return {
        ...state,
        lastAttemptFinish: null,
        isUnfrozenSuccess: true,
        isError: false,
        frozenExams,
        availableForFreezeExams,
        examsForUnfreeze: []
    };
}

function freezeError(state: IFreezeState): IFreezeState {
    return {
        ...state,
        isError: true
    };
}

function chooseFreezeExams(
    state: IFreezeState,
    action: IChooseForFreeze
): IFreezeState {
    const { exams } = action.payload;

    return {
        ...state,
        examsForFreeze: exams
    };
}

function chooseUnfreezeExams(
    state: IFreezeState,
    action: IChooseForUnfreeze
): IFreezeState {
    const { exams } = action.payload;

    return {
        ...state,
        examsForUnfreeze: exams
    };
}

export default handleActions<IFreezeState, any>({
    [ActionTypes.FREEZE]: freeze,
    [ActionTypes.FREEZE_SUCCESS]: freezeSuccess,
    [ActionTypes.UNFREEZE]: unfreeze,
    [ActionTypes.UNFREEZE_SUCCESS]: unfreezeSuccess,
    [ActionTypes.FREEZE_ERROR]: freezeError,
    [ActionTypes.UNFREEZE_ERROR]: freezeError,
    [ActionTypes.CHOOSE_FOR_FREEZE]: chooseFreezeExams,
    [ActionTypes.CHOOSE_FOR_UNFREEZE]: chooseUnfreezeExams
}, initialState);
