import { all, call, takeLatest, put } from 'redux-saga/effects';

import { serverUrls } from '../../../common/server-urls';

import fetch from '../../common/fetch';

import { ActionTypes, IFreezeResponse, IFreeze, IUnfreeze } from './types';
import { freezeSuccess, unfreezeSuccess, setFreezeError, setUnfreezeError } from './actions';

function *freeze(action: IFreeze) {
    try {
        const { exams } = action.payload;
        const url = serverUrls.freeze.build();

        const res: IFreezeResponse = yield call(fetch, url, {
            method: 'POST',
            body: JSON.stringify({ examIds: exams }),
            headers: {
                'Content-Type': 'application/json'
            }
        });

        const { lastAttemptFinish } = res;

        yield put(freezeSuccess(exams, lastAttemptFinish));
    } catch (err) {
        yield put(setFreezeError());
    }

}

function *unfreeze(action: IUnfreeze) {
    try {
        const { exams } = action.payload;
        const url = serverUrls.unfreeze.build();

        yield call(fetch, url, {
            method: 'POST',
            body: JSON.stringify({ examIds: exams }),
            headers: {
                'Content-Type': 'application/json'
            }
        });

        yield put(unfreezeSuccess(exams));
    } catch (err) {
        yield put(setUnfreezeError());
    }

}

export default function *() {
    yield all([
        takeLatest(ActionTypes.FREEZE, freeze),
        takeLatest(ActionTypes.UNFREEZE, unfreeze)
    ]);
}
