import { Action } from 'redux';

export interface IFreezeState {
    isFrozen?: Boolean,
    lastAttemptFinish?: string | null,
    isUnfrozenSuccess?: Boolean,
    isError?: Boolean,
    examsForFreeze: number[],
    examsForUnfreeze: number[],
    availableForFreezeExams: number[],
    frozenExams: number[]
}

export enum ActionTypes {
    FREEZE = '[freeze] freeze',
    UNFREEZE = '[freeze] unfreeze',
    FREEZE_SUCCESS = '[freeze] freeze success',
    UNFREEZE_SUCCESS = '[freeze] unfreeze success',
    FREEZE_ERROR = '[freeze] freeze error',
    UNFREEZE_ERROR = '[freeze] unfreeze error',
    CHOOSE_FOR_FREEZE = '[freeze] choose for freeze',
    CHOOSE_FOR_UNFREEZE = '[freeze] choose for unfreeze'
}

interface IExamsPayload {
    exams: number[]
}

export interface IFreeze extends Action {
    type: ActionTypes.FREEZE,
    payload: IExamsPayload
}

export interface IUnfreeze extends Action {
    type: ActionTypes.UNFREEZE,
    payload: IExamsPayload
}

export interface IFreezeResponse {
    lastAttemptFinish: string,
    exams: number[]
}

export interface IFreezeSuccess extends Action {
    type: ActionTypes.FREEZE_SUCCESS,
    payload: IFreezeResponse
}

export interface IUnfreezeSuccess extends Action {
    type: ActionTypes.UNFREEZE_SUCCESS,
    payload: IExamsPayload
}

export interface IFreezeError extends Action {
    type: ActionTypes.FREEZE_ERROR
}

export interface IUnfreezeError extends Action {
    type: ActionTypes.UNFREEZE_ERROR
}

export interface IChooseForFreeze extends Action {
    type: ActionTypes.CHOOSE_FOR_FREEZE,
    payload: IExamsPayload
}

export interface IChooseForUnfreeze extends Action {
    type: ActionTypes.CHOOSE_FOR_UNFREEZE,
    payload: IExamsPayload
}

export type FreezeAction =
    | IFreeze
    | IUnfreeze
    | IFreezeSuccess
    | IUnfreezeSuccess
    | IFreezeError
    | IUnfreezeError
    | IChooseForFreeze
    | IChooseForUnfreeze;
