import { applyMiddleware, combineReducers, compose, createStore, Middleware } from 'redux';
import { composeWithDevTools } from 'redux-devtools-extension/developmentOnly';
import { reducer as toastrReducer } from 'react-redux-toastr';

import { logger, sagaMiddleware } from './middlewares';
import rootSaga from './saga';

import { ICommonState, IStatisticsState } from './common/types';

import commonReducer from './common/reducer';
import attemptByNumberReducer from './attemptByNumber/reducer';
import attemptsByLoginReducer from './attemptsByLogin/reducer';
import bansByLoginReducer from './bansByLogin/reducer';
import bansAggregationReducer from './bansAggregation/reducer';
import dataByCertNumberReducer from './dataByCertNumber/reducer';
import certificatesByPeriodReducer, {
    ICertificatesByPeriodState
} from './certificatesByPeriod/reducer';
import dataByPeriodReducer, { IDataByPeriodState } from './dataByPeriod/reducer';
import trialsByPeriodReducer, { ITrialsByPeriodState } from './trialsByPeriod/reducer';
import agenciesStatReducer, { IAgenciesStatState } from './agenciesStat/reducer';
import questionsStatisticsReducer,
{ IQuestionsStatisticsState }
    from './questionsStatistics/reducer';

import { IVideosState } from './videos/types';
import videosReducer from './videos/reducer';

import { IFreezeState } from './freeze/types';
import freezeReducer from './freeze/reducer';

import { ITestsState } from './tests/types';
import testsReducer from './tests/reducer';

import { IEditExamFormState } from './editExamForm/types';
import editExamFormReducer from './editExamForm/reducer';

import { IExamDataState } from './examData/types';
import examDataReducer from './examData/reducer';

import { ITabsState } from './tabs/types';
import tabsReducer from './tabs/reducer';

import { INullifyAttemptState } from './nullifyAttempt/types';
import nullifyAttemptReducer from './nullifyAttempt/reducer';

import { INullifyCertificateState } from './nullifyCertificate/types';
import nullifyCertificateReducer from './nullifyCertificate/reducer';

import { IBansState } from './bans/types';
import bansReducer from './bans/reducer';

import { IBanFormState } from './banForm/types';
import banFormReducer from './banForm/reducer';

import { IUnbanFormState } from './unbanForm/types';
import unbanFormReducer from './unbanForm/reducer';

export interface ApplicationState {
    common: ICommonState,
    attemptByNumber: IStatisticsState,
    attemptsByLogin: IStatisticsState,
    bansByLogin: IStatisticsState,
    dataByCertNumber: IStatisticsState,
    freeze: IFreezeState,
    dataByPeriod: IDataByPeriodState,
    bansAggregation: IDataByPeriodState,
    certificatesByPeriod: ICertificatesByPeriodState,
    trialsByPeriod: ITrialsByPeriodState,
    questionsStatistics: IQuestionsStatisticsState,
    agenciesStat: IAgenciesStatState,
    videos: IVideosState,
    tests: ITestsState,
    editExamForm: IEditExamFormState,
    examData: IExamDataState,
    tabs: ITabsState,
    nullifyAttempt: INullifyAttemptState,
    nullifyCertificate: INullifyCertificateState,
    bans: IBansState,
    banForm: IBanFormState,
    unbanForm: IUnbanFormState
}

const reducers = {
    common: commonReducer,
    attemptByNumber: attemptByNumberReducer,
    attemptsByLogin: attemptsByLoginReducer,
    bansByLogin: bansByLoginReducer,
    dataByCertNumber: dataByCertNumberReducer,
    freeze: freezeReducer,
    dataByPeriod: dataByPeriodReducer,
    bansAggregation: bansAggregationReducer,
    certificatesByPeriod: certificatesByPeriodReducer,
    trialsByPeriod: trialsByPeriodReducer,
    questionsStatistics: questionsStatisticsReducer,
    agenciesStat: agenciesStatReducer,
    toastr: toastrReducer,
    videos: videosReducer,
    tests: testsReducer,
    editExamForm: editExamFormReducer,
    examData: examDataReducer,
    tabs: tabsReducer,
    nullifyAttempt: nullifyAttemptReducer,
    nullifyCertificate: nullifyCertificateReducer,
    bans: bansReducer,
    banForm: banFormReducer,
    unbanForm: unbanFormReducer
};

interface IStoreOptions {
    isDev?: boolean
}

function getMiddlewares(options: IStoreOptions) {
    return [
        sagaMiddleware,
        options.isDev && logger
    ].filter(Boolean) as Middleware[];
}

function configureStore(initialState = {}, options: IStoreOptions = { isDev: true }) {
    const enhancer = (options.isDev ? composeWithDevTools : compose) as typeof compose;
    const composedMiddlewares = enhancer(applyMiddleware(...getMiddlewares(options)));
    const rootReducer = combineReducers<ApplicationState>(reducers);

    const store = createStore(rootReducer, initialState, composedMiddlewares);

    sagaMiddleware.run(rootSaga);

    return store;
}

export default configureStore;
