import { Middleware } from 'redux';
import createSagaMiddleware from 'redux-saga';

const logger: Middleware = store => next => action => {
    console.group(action.type);
    console.info('Dispatching', action);

    const result = next(action);

    console.info('Next state', store.getState());
    console.groupEnd();

    return result;
};

const sagaMiddleware = createSagaMiddleware();

export { logger, sagaMiddleware };
