import { IDetailsError } from 'common/utils/error';

import {
    ActionTypes,
    ITypeAttemptIdsAction,
    IFocusAttemptIdsAction,
    IBlurAttemptIdsAction,
    IGetAttemptsInfoAction,
    IGetAttemptsInfoSuccessAction,
    IGetAttemptsInfoErrorAction,
    IAttemptInfo,
    IPressNullifyAction,
    IDeclineAction,
    IConfirmAction,
    ISubmitErrorAction,
    ISubmitSuccessAction
} from './types';

export function typeAttemptIdsAction(inputText: string): ITypeAttemptIdsAction {
    return { type: ActionTypes.TYPE_ATTEMPT_IDS, payload: { inputText } };
}

export function focusAttemptIds(): IFocusAttemptIdsAction {
    return { type: ActionTypes.FOCUS_ATTEMPT_IDS };
}

export function blurAttemptIds(): IBlurAttemptIdsAction {
    return { type: ActionTypes.BLUR_ATTEMPT_IDS };
}

export function getAttemptsInfo(attemptIds: string): IGetAttemptsInfoAction {
    return { type: ActionTypes.GET_ATTEMPTS_INFO, payload: { attemptIds } };
}

export function getAttemptsInfoSuccess(
    attemptsInfo: IAttemptInfo[]
): IGetAttemptsInfoSuccessAction {
    return {
        type: ActionTypes.GET_ATTEMPTS_INFO_SUCCESS,
        payload: { attemptsInfo }
    };
}

export function getAttemptsInfoError(error: IDetailsError): IGetAttemptsInfoErrorAction {
    return { type: ActionTypes.GET_ATTEMPTS_INFO_ERROR, payload: error };
}

export function showConfirmation(): IPressNullifyAction {
    return { type: ActionTypes.PRESS_NULLIFY };
}

export function confirm(attemptIds: string): IConfirmAction {
    return { type: ActionTypes.CONFIRM, payload: { attemptIds } };
}

export function decline(): IDeclineAction {
    return { type: ActionTypes.DECLINE };
}

export function submitSuccess(notFoundAttempts: number[]): ISubmitSuccessAction {
    return { type: ActionTypes.SUBMIT_SUCCESS, payload: { notFoundAttempts } };
}

export function submitError(error: IDetailsError): ISubmitErrorAction {
    return { type: ActionTypes.SUBMIT_ERROR, payload: error };
}
