import fetch from 'client/common/fetch';

import { serverUrls } from 'common/server-urls';

import { all, call, takeLatest, put } from 'redux-saga/effects';

import {
    ActionTypes,
    IGetAttemptsInfoAction,
    IConfirmAction,
    IGetAttemptsInfoSuccessPayload,
    INullifySuccessPayload
} from './types';

import {
    getAttemptsInfoSuccess,
    getAttemptsInfoError,
    submitError,
    submitSuccess
} from './actions';

import { parseAttemptIds } from './reducer';

function *getAttemptsInfo(action: IGetAttemptsInfoAction) {
    try {
        const { attemptIds } = action.payload;
        const body = parseAttemptIds(attemptIds);

        const url = serverUrls.getAttemptsInfo.build();

        const res: IGetAttemptsInfoSuccessPayload = yield call(fetch, url, {
            method: 'POST',
            body: JSON.stringify({ attemptIds: body }),
            headers: {
                'Content-Type': 'application/json'
            }
        });

        const { attemptsInfo } = res;

        yield put(getAttemptsInfoSuccess(attemptsInfo));
    } catch (err) {
        yield put(getAttemptsInfoError(err.data || err));
    }
}

function *nullify(action: IConfirmAction) {
    try {
        const { attemptIds } = action.payload;
        const body = parseAttemptIds(attemptIds).map(attemptId => Number(attemptId));

        const url = serverUrls.nullifyAttempt.build();

        const res: INullifySuccessPayload = yield call(fetch, url, {
            method: 'POST',
            body: JSON.stringify({ attemptIds: body }),
            headers: {
                'Content-Type': 'application/json'
            }
        });

        const { notFoundAttempts } = res;

        yield put(submitSuccess(notFoundAttempts));
    } catch (err) {
        yield put(submitError(err.data || err));
    }
}

export default function *() {
    yield all([
        takeLatest(ActionTypes.GET_ATTEMPTS_INFO, getAttemptsInfo),
        takeLatest(ActionTypes.CONFIRM, nullify)
    ]);
}
