import { Action } from 'redux-actions'; // eslint-disable-line import/named

import { ITypePayload } from 'client/store/common/types';
import { IDetailsError } from 'common/utils/error';

export interface IAttemptInfo {
    trialId: number,
    nullified: number,
    started: Date,
    login: string,
    trialTemplateSlug: string
}

export interface INullifyAttemptState {
    attemptIds: string,
    hasFocusAttemptIds: boolean,
    isValidAttemptIds: boolean,
    hasAttemptIds: boolean,
    isPending: boolean,
    requestError: IDetailsError | null,
    isVisibleConfirmationModal: boolean,
    attemptsInfo: IAttemptInfo[] | null,
    isNullifySuccess: boolean,
    notFoundAttempts: number[] | null
}

export enum ActionTypes {
    TYPE_ATTEMPT_IDS = '[nullifyAttempt] type attempt ids',
    FOCUS_ATTEMPT_IDS = '[nullifyAttempt] focus attempt ids',
    BLUR_ATTEMPT_IDS = '[nullifyAttempt] blur attempt ids',
    GET_ATTEMPTS_INFO = '[nullifyAttempt] get attempts info',
    GET_ATTEMPTS_INFO_SUCCESS = '[nullifyAttempt] get attempts info success',
    GET_ATTEMPTS_INFO_ERROR = '[nullifyAttempt] get attempts info error',
    PRESS_NULLIFY = '[nullifyAttempt] press nullify',
    CONFIRM = '[nullifyAttempt] confirm',
    DECLINE = '[nullifyAttempt] decline',
    SUBMIT_SUCCESS = '[nullifyAttempt] submit success',
    SUBMIT_ERROR = '[nullifyAttempt] submit error'
}

export interface ITypeAttemptIdsAction extends Action<ITypePayload> {
    type: ActionTypes.TYPE_ATTEMPT_IDS,
    payload: ITypePayload
}

export interface IFocusAttemptIdsAction extends Action<null> {
    type: ActionTypes.FOCUS_ATTEMPT_IDS
}

export interface IBlurAttemptIdsAction extends Action<null> {
    type: ActionTypes.BLUR_ATTEMPT_IDS
}

export interface IGetAttemptsInfoPayload {
    attemptIds: string
}

export interface IGetAttemptsInfoAction extends Action<IGetAttemptsInfoPayload> {
    type: ActionTypes.GET_ATTEMPTS_INFO,
    payload: IGetAttemptsInfoPayload
}

export interface IGetAttemptsInfoSuccessPayload {
    attemptsInfo: IAttemptInfo[]
}

export interface IGetAttemptsInfoSuccessAction extends Action<IGetAttemptsInfoSuccessPayload> {
    type: ActionTypes.GET_ATTEMPTS_INFO_SUCCESS,
    payload: IGetAttemptsInfoSuccessPayload
}

export interface IGetAttemptsInfoErrorAction extends Action<IDetailsError> {
    type: ActionTypes.GET_ATTEMPTS_INFO_ERROR,
    payload: IDetailsError
}

export interface IPressNullifyAction extends Action<null> {
    type: ActionTypes.PRESS_NULLIFY
}

interface IConfirmPayload {
    attemptIds: string
}

export interface IConfirmAction extends Action<IConfirmPayload> {
    type: ActionTypes.CONFIRM,
    payload: IConfirmPayload
}

export interface IDeclineAction extends Action<null> {
    type: ActionTypes.DECLINE
}

export interface INullifySuccessPayload {
    notFoundAttempts: number[]
}

export interface ISubmitSuccessAction extends Action<INullifySuccessPayload> {
    type: ActionTypes.SUBMIT_SUCCESS,
    payload: INullifySuccessPayload
}

export interface ISubmitErrorAction extends Action<IDetailsError> {
    type: ActionTypes.SUBMIT_ERROR,
    payload: IDetailsError
}

export type NullifyAttemptsAction =
    | ITypeAttemptIdsAction
    | IFocusAttemptIdsAction
    | IBlurAttemptIdsAction
    | IGetAttemptsInfoAction
    | IGetAttemptsInfoSuccessAction
    | IGetAttemptsInfoErrorAction
    | IPressNullifyAction
    | IConfirmAction
    | IDeclineAction
    | ISubmitSuccessAction
    | ISubmitErrorAction;

export type NullifyAttemptsPayload =
    | ITypePayload
    | IGetAttemptsInfoPayload
    | IGetAttemptsInfoSuccessPayload
    | IDetailsError
    | IConfirmPayload
    |INullifySuccessPayload;
