import { IDetailsError } from 'common/utils/error';

import {
    ActionTypes,
    ITypeCertificateIdsAction,
    IFocusCertificateIdsAction,
    IBlurCertificateIdsAction,
    IGetCertsInfoAction,
    IGetCertsInfoSuccessAction,
    IGetCertsInfoErrorAction,
    ICertificatesInfo,
    IPressNullifyAction,
    IDeclineAction,
    IConfirmAction,
    ISubmitErrorAction,
    ISubmitSuccessAction
} from './types';

export function typeCertificateIdsAction(inputText: string): ITypeCertificateIdsAction {
    return { type: ActionTypes.TYPE_CERTIFICATE_IDS, payload: { inputText } };
}

export function focusCertificateIds(): IFocusCertificateIdsAction {
    return { type: ActionTypes.FOCUS_CERTIFICATE_IDS };
}

export function blurCertificateIds(): IBlurCertificateIdsAction {
    return { type: ActionTypes.BLUR_CERTIFICATE_IDS };
}

export function getCertificatesInfo(certificateIds: string): IGetCertsInfoAction {
    return { type: ActionTypes.GET_CERTIFICATES_INFO, payload: { certificateIds } };
}

export function getCertificatesInfoSuccess(
    certificatesInfo: ICertificatesInfo[]
): IGetCertsInfoSuccessAction {
    return {
        type: ActionTypes.GET_CERTIFICATES_INFO_SUCCESS,
        payload: { certificatesInfo }
    };
}

export function getCertificatesInfoError(error: IDetailsError): IGetCertsInfoErrorAction {
    return { type: ActionTypes.GET_CERTIFICATES_INFO_ERROR, payload: error };
}

export function showConfirmation(): IPressNullifyAction {
    return { type: ActionTypes.PRESS_NULLIFY };
}

export function confirm(certificateIds: string): IConfirmAction {
    return { type: ActionTypes.CONFIRM, payload: { certificateIds } };
}

export function decline(): IDeclineAction {
    return { type: ActionTypes.DECLINE };
}

export function submitSuccess(): ISubmitSuccessAction {
    return { type: ActionTypes.SUBMIT_SUCCESS };
}

export function submitError(error: IDetailsError): ISubmitErrorAction {
    return { type: ActionTypes.SUBMIT_ERROR, payload: error };
}
