import fetch from 'client/common/fetch';

import { serverUrls } from 'common/server-urls';

import { all, call, takeLatest, put } from 'redux-saga/effects';

import {
    ActionTypes,
    IGetCertsInfoAction,
    IConfirmAction,
    IGetCertsInfoSuccessPayload
} from './types';

import {
    getCertificatesInfoSuccess,
    getCertificatesInfoError,
    submitError,
    submitSuccess
} from './actions';

import { parseCertificateIds } from './reducer';

function *getCertificatesInfo(action: IGetCertsInfoAction) {
    try {
        const { certificateIds } = action.payload;
        const body = parseCertificateIds(certificateIds);

        const url = serverUrls.getCertificatesInfo.build();

        const res: IGetCertsInfoSuccessPayload = yield call(fetch, url, {
            method: 'POST',
            body: JSON.stringify({ certIds: body }),
            headers: {
                'Content-Type': 'application/json'
            }
        });

        const { certificatesInfo } = res;

        yield put(getCertificatesInfoSuccess(certificatesInfo));
    } catch (err) {
        yield put(getCertificatesInfoError(err.data || err));
    }
}

function *nullify(action: IConfirmAction) {
    try {
        const { certificateIds } = action.payload;
        const body = parseCertificateIds(certificateIds).map(certId => Number(certId));

        const url = serverUrls.nullifyCertificates.build();

        yield call(fetch, url, {
            method: 'POST',
            body: JSON.stringify({ certIds: body }),
            headers: {
                'Content-Type': 'application/json'
            }
        });

        yield put(submitSuccess());
    } catch (err) {
        yield put(submitError(err.data || err));
    }
}

export default function *() {
    yield all([
        takeLatest(ActionTypes.GET_CERTIFICATES_INFO, getCertificatesInfo),
        takeLatest(ActionTypes.CONFIRM, nullify)
    ]);
}
