import { Action } from 'redux-actions'; // eslint-disable-line import/named

import { ITypePayload } from 'client/store/common/types';
import { IDetailsError } from 'common/utils/error';
import RequestStatus from 'common/types/requestStatus';

export interface ICertificatesInfo {
    id: number,
    isActive: boolean,
    confirmedDate: Date,
    dueDate: Date,
    trialId: number,
    isTrialNullified: boolean,
    login: string,
    examSlug: string
}

export interface INullifyCertificateState {
    certIds: string,
    isValidCertIds: boolean,
    hasFocusCertIds: boolean,
    nullifyCertsStatus: RequestStatus | null,
    getInfoStatus: RequestStatus | null,
    requestError: IDetailsError | null,
    isVisibleConfirmationModal: boolean,
    certificatesInfo: ICertificatesInfo[] | null
}

export enum ActionTypes {
    TYPE_CERTIFICATE_IDS = '[nullifyCertificate] type certificate ids',
    FOCUS_CERTIFICATE_IDS = '[nullifyCertificate] focus certificate ids',
    BLUR_CERTIFICATE_IDS = '[nullifyCertificate] blur certificate ids',
    GET_CERTIFICATES_INFO = '[nullifyCertificate] get certificates info',
    GET_CERTIFICATES_INFO_SUCCESS = '[nullifyCertificate] get certificates info success',
    GET_CERTIFICATES_INFO_ERROR = '[nullifyCertificate] get certificates info error',
    PRESS_NULLIFY = '[nullifyCertificate] press nullify',
    CONFIRM = '[nullifyCertificate] confirm',
    DECLINE = '[nullifyCertificate] decline',
    SUBMIT_SUCCESS = '[nullifyCertificate] submit success',
    SUBMIT_ERROR = '[nullifyCertificate] submit error'
}

export interface ITypeCertificateIdsAction extends Action<ITypePayload> {
    type: ActionTypes.TYPE_CERTIFICATE_IDS,
    payload: ITypePayload
}

export interface IFocusCertificateIdsAction extends Action<null> {
    type: ActionTypes.FOCUS_CERTIFICATE_IDS
}

export interface IBlurCertificateIdsAction extends Action<null> {
    type: ActionTypes.BLUR_CERTIFICATE_IDS
}

export interface IGetCertsInfoPayload {
    certificateIds: string
}

export interface IGetCertsInfoAction extends Action<IGetCertsInfoPayload> {
    type: ActionTypes.GET_CERTIFICATES_INFO,
    payload: IGetCertsInfoPayload
}

export interface IGetCertsInfoSuccessPayload {
    certificatesInfo: ICertificatesInfo[]
}

export interface IGetCertsInfoSuccessAction extends Action<IGetCertsInfoSuccessPayload> {
    type: ActionTypes.GET_CERTIFICATES_INFO_SUCCESS,
    payload: IGetCertsInfoSuccessPayload
}

export interface IGetCertsInfoErrorAction extends Action<IDetailsError> {
    type: ActionTypes.GET_CERTIFICATES_INFO_ERROR,
    payload: IDetailsError
}

export interface IPressNullifyAction extends Action<null> {
    type: ActionTypes.PRESS_NULLIFY
}

interface IConfirmPayload {
    certificateIds: string
}

export interface IConfirmAction extends Action<IConfirmPayload> {
    type: ActionTypes.CONFIRM,
    payload: IConfirmPayload
}

export interface IDeclineAction extends Action<null> {
    type: ActionTypes.DECLINE
}

export interface ISubmitSuccessAction extends Action<null> {
    type: ActionTypes.SUBMIT_SUCCESS,
}

export interface ISubmitErrorAction extends Action<IDetailsError> {
    type: ActionTypes.SUBMIT_ERROR,
    payload: IDetailsError
}

export type NullifyCertificatesAction =
    | ITypeCertificateIdsAction
    | IFocusCertificateIdsAction
    | IBlurCertificateIdsAction
    | IGetCertsInfoAction
    | IGetCertsInfoSuccessAction
    | IGetCertsInfoErrorAction
    | IPressNullifyAction
    | IConfirmAction
    | IDeclineAction
    | ISubmitSuccessAction
    | ISubmitErrorAction;

export type NullifyCertificatesPayload =
    | ITypePayload
    | IGetCertsInfoPayload
    | IGetCertsInfoSuccessPayload
    | IConfirmPayload
    | IDetailsError;
