import {
    ActionTypes,
    IFromDateChangeAction,
    IToDateChangeAction,
    IExamsChoiceAction
} from './types';

export function changeFromDate(date: Date): IFromDateChangeAction {
    return { type: ActionTypes.FROM_DATE_CHANGE, payload: { date } };
}

export function changeToDate(date: Date): IToDateChangeAction {
    return { type: ActionTypes.TO_DATE_CHANGE, payload: { date } };
}

export function chooseExams(exams: string[]): IExamsChoiceAction {
    return { type: ActionTypes.EXAMS_CHOICE, payload: { exams } };
}
