import { handleActions } from 'redux-actions';

import { PeriodDateType } from 'client/store/common/types';

import {
    ActionTypes,
    IFromDateChangeAction,
    QuestionsStatisticsPayload,
    IToDateChangeAction,
    IExamsChoiceAction
} from './types';

export interface IQuestionsStatisticsState {
    from: Date,
    to: Date,
    error?: PeriodDateType,
    exams: string[]
}

const fromDate = new Date();

fromDate.setMonth(fromDate.getMonth() - 1);

const initialState: IQuestionsStatisticsState = {
    from: fromDate,
    to: new Date(),
    exams: []
};

function changeFromDate(
    state: IQuestionsStatisticsState,
    action: IFromDateChangeAction
): IQuestionsStatisticsState {
    const { date } = action.payload;
    const { from, to } = state;
    const hasError = to && to < date;

    return Object.assign({}, state, {
        from: hasError ? from : date,
        error: hasError ? 'from' : undefined
    });
}

function changeToDate(
    state: IQuestionsStatisticsState,
    action: IToDateChangeAction
): IQuestionsStatisticsState {
    const { date } = action.payload;
    const { from, to } = state;
    const hasError = from && from > date;

    return Object.assign({}, state, {
        to: hasError ? to : date,
        error: hasError ? 'to' : undefined
    });
}

function chooseExams(
    state: IQuestionsStatisticsState,
    action: IExamsChoiceAction
): IQuestionsStatisticsState {
    const { exams } = action.payload;

    return Object.assign({}, state, { exams });
}

export default handleActions<IQuestionsStatisticsState, QuestionsStatisticsPayload>({
    [ActionTypes.FROM_DATE_CHANGE]: changeFromDate,
    [ActionTypes.TO_DATE_CHANGE]: changeToDate,
    [ActionTypes.EXAMS_CHOICE]: chooseExams
}, initialState);
