import { Action } from 'redux-actions'; // eslint-disable-line import/named

export enum ActionTypes {
    FROM_DATE_CHANGE = '[questionsStatistics] start date change',
    TO_DATE_CHANGE = '[questionsStatistics] end date change',
    EXAMS_CHOICE = '[questionsStatistics] exams choice'
}

interface IDatePayload {
    date: Date
}

export interface IFromDateChangeAction extends Action<IDatePayload> {
    type: ActionTypes.FROM_DATE_CHANGE,
    payload: IDatePayload
}

export interface IToDateChangeAction extends Action<IDatePayload> {
    type: ActionTypes.TO_DATE_CHANGE,
    payload: IDatePayload,
}

interface IExamsPayload {
    exams: string[]
}

export interface IExamsChoiceAction extends Action<IExamsPayload> {
    type: ActionTypes.EXAMS_CHOICE,
    payload: IExamsPayload
}

export type QuestionsStatisticsAction =
    | IFromDateChangeAction
    | IToDateChangeAction
    | IExamsChoiceAction;

export type QuestionsStatisticsPayload =
    | IDatePayload
    | IExamsPayload;
