import { all } from 'redux-saga/effects';

import freezeSaga from './freeze/saga';
import agenciesStatSaga from './agenciesStat/saga';
import videosSaga from './videos/saga';
import editExamFormSaga from './editExamForm/saga';
import examDataSaga from './examData/saga';
import tabsSaga from './tabs/saga';
import nullifyAttemptSaga from './nullifyAttempt/saga';
import nullifyCertificateSaga from './nullifyCertificate/saga';
import bansSaga from './bans/saga';
import banFormSaga from './banForm/saga';
import unbanFormSaga from './unbanForm/saga';

export default function *rootSaga() {
    yield all([
        freezeSaga(),
        agenciesStatSaga(),
        videosSaga(),
        editExamFormSaga(),
        examDataSaga(),
        tabsSaga(),
        nullifyAttemptSaga(),
        nullifyCertificateSaga(),
        bansSaga(),
        banFormSaga(),
        unbanFormSaga()
    ]);
}
