import { handleActions } from 'redux-actions';

import {
    ActionTypes,
    TabsPayload,
    ITabsState,
    ISelectActiveAction
} from './types';

const initialState: ITabsState = {
    activeTabName: ''
};

function selectActive(
    state: ITabsState,
    action: ISelectActiveAction
): ITabsState {
    const { name } = action.payload;

    return Object.assign({}, state, { activeTabName: name });
}

export default handleActions<ITabsState, TabsPayload>({
    [ActionTypes.SELECT_ACTIVE]: selectActive
}, initialState);
