import { Action } from 'redux-actions'; // eslint-disable-line import/named
import { History } from 'history';

export enum ActionTypes {
    SELECT_ACTIVE = '[tabs] select active'
}

export interface ITabsState {
    activeTabName: string
}

interface ISelectActivePayload {
    name: string,
    history: History
}

export interface ISelectActiveAction extends Action<ISelectActivePayload> {
    type: ActionTypes.SELECT_ACTIVE,
    payload: ISelectActivePayload
}

export type TabsAction =
    | ISelectActiveAction;

export type TabsPayload =
    | ISelectActivePayload;
