import { handleActions } from 'redux-actions';

import { PeriodDateType } from '../common/types';

import {
    ActionTypes,
    IFromDateChangeAction,
    TrialsByPeriodPayload,
    IToDateChangeAction,
    IExamsChoiceAction,
    ILoginsChangeAction
} from './types';

export interface ITrialsByPeriodState {
    from: Date,
    to: Date,
    error?: PeriodDateType,
    exams: string[],
    logins?: string
}

const fromDate = new Date();

fromDate.setMonth(fromDate.getMonth() - 1);

const initialState: ITrialsByPeriodState = {
    from: fromDate,
    to: new Date(),
    exams: []
};

function changeFromDate(
    state: ITrialsByPeriodState,
    action: IFromDateChangeAction
): ITrialsByPeriodState {
    const { date } = action.payload;
    const { from, to } = state;
    const hasError = to && to < date;

    return Object.assign({}, state, {
        from: hasError ? from : date,
        error: hasError ? 'from' : undefined
    });
}

function changeToDate(
    state: ITrialsByPeriodState,
    action: IToDateChangeAction
): ITrialsByPeriodState {
    const { date } = action.payload;
    const { from, to } = state;
    const hasError = from && from > date;

    return Object.assign({}, state, {
        to: hasError ? to : date,
        error: hasError ? 'to' : undefined
    });
}

function chooseExams(
    state: ITrialsByPeriodState,
    action: IExamsChoiceAction
): ITrialsByPeriodState {
    const { exams } = action.payload;

    return Object.assign({}, state, { exams });
}

function changeLogins(
    state: ITrialsByPeriodState,
    action: ILoginsChangeAction
) : ITrialsByPeriodState {
    const { logins } = action.payload;

    return Object.assign({}, state, { logins });
}

export default handleActions<ITrialsByPeriodState, TrialsByPeriodPayload>({
    [ActionTypes.FROM_DATE_CHANGE]: changeFromDate,
    [ActionTypes.TO_DATE_CHANGE]: changeToDate,
    [ActionTypes.EXAMS_CHOICE]: chooseExams,
    [ActionTypes.LOGINS_CHANGE]: changeLogins
}, initialState);
