import { Action } from 'redux-actions'; // eslint-disable-line import/named

export enum ActionTypes {
    FROM_DATE_CHANGE = '[trials by period] start date change',
    TO_DATE_CHANGE = '[trials by period] end date change',
    EXAMS_CHOICE = '[trials by period] exams choice',
    LOGINS_CHANGE = '[trials by period] logins change'
}

interface IDatePayload {
    date: Date
}

export interface IFromDateChangeAction extends Action<IDatePayload> {
    type: ActionTypes.FROM_DATE_CHANGE,
    payload: IDatePayload
}

export interface IToDateChangeAction extends Action<IDatePayload> {
    type: ActionTypes.TO_DATE_CHANGE,
    payload: IDatePayload,
}

interface IExamsPayload {
    exams: string[]
}

export interface IExamsChoiceAction extends Action<IExamsPayload> {
    type: ActionTypes.EXAMS_CHOICE,
    payload: IExamsPayload
}

interface ILoginsPayload {
    logins: string
}

export interface ILoginsChangeAction extends Action<ILoginsPayload> {
    type: ActionTypes.LOGINS_CHANGE,
    payload: ILoginsPayload
}

export type TrialsByPeriodAction =
    | IFromDateChangeAction
    | IToDateChangeAction
    | IExamsChoiceAction
    | ILoginsChangeAction;

export type TrialsByPeriodPayload =
    | IDatePayload
    | IExamsPayload
    | ILoginsPayload;
