import { IDetailsError } from 'common/utils/error';

import {
    ActionTypes,
    IUnbanAction,
    IUnbanPayload,
    IUnbanSuccessAction,
    IUnbanErrorAction,
    IChooseExamsAction,
    ITypeLoginAction,
    ITypeReasonAction,
    IToggleSuperUnbanAction,
    IPressUnbanAction,
    IDeclineAction
} from './types';

export function chooseExams(exams: string[]): IChooseExamsAction {
    return { type: ActionTypes.CHOOSE_EXAMS, payload: { exams } };
}

export function typeLogin(inputText: string): ITypeLoginAction {
    return { type: ActionTypes.TYPE_LOGIN, payload: { inputText } };
}

export function typeReason(inputText: string): ITypeReasonAction {
    return { type: ActionTypes.TYPE_REASON, payload: { inputText } };
}

export function toggleSuperUnban(): IToggleSuperUnbanAction {
    return { type: ActionTypes.TOGGLE_SUPER_UNBAN };
}

export function pressUnban(): IPressUnbanAction {
    return { type: ActionTypes.PRESS_UNBAN };
}

export function decline(): IDeclineAction {
    return { type: ActionTypes.DECLINE };
}

export function unban(unbanData: IUnbanPayload): IUnbanAction {
    return { type: ActionTypes.UNBAN, payload: unbanData };
}

export function unbanSuccess(): IUnbanSuccessAction {
    return { type: ActionTypes.UNBAN_SUCCESS };
}

export function unbanError(error: IDetailsError): IUnbanErrorAction {
    return { type: ActionTypes.UNBAN_ERROR, payload: error };
}
