import fetch from 'client/common/fetch';

import { serverUrls } from 'common/server-urls';

import { all, call, takeLatest, put } from 'redux-saga/effects';

import {
    ActionTypes,
    IUnbanAction
} from './types';

import {
    unbanSuccess,
    unbanError
} from './actions';

function *unban(action: IUnbanAction) {
    try {
        const { examsForUnban, reason, isSuperUnban, userLogin } = action.payload;

        const parsedLogin = userLogin.trim();
        const trialTemplateIds = examsForUnban.map(examId => Number(examId));
        const unbanUrl = serverUrls.unban.build();

        yield call(fetch, unbanUrl, {
            method: 'POST',
            body: JSON.stringify({
                login: parsedLogin,
                isSuperUnban,
                reason,
                trialTemplateIds
            }),
            headers: {
                'Content-Type': 'application/json'
            }
        });

        yield put(unbanSuccess());
    } catch (err) {
        yield put(unbanError(err.data || err));
    }
}

export default function *() {
    yield all([
        takeLatest(ActionTypes.UNBAN, unban)
    ]);
}
