import { Action } from 'redux-actions'; // eslint-disable-line import/named

import { ITypePayload } from 'client/store/common/types';
import { IDetailsError } from 'common/utils/error';
import RequestStatus from 'common/types/requestStatus';

export interface IUnbanFormState {
    examsForUnban: string[],
    userLogin: string,
    unbanStatus: RequestStatus | null,
    requestError: IDetailsError | null,
    reason: string,
    isSuperUnban: boolean,
    isVisibleConfirmationModal: boolean,
    submitErrors: string[] | null
}

export enum ActionTypes {
    CHOOSE_EXAMS = '[unbanForm] choose exams',
    TYPE_LOGIN = '[unbanForm] type login',
    TYPE_REASON = '[unbanForm] type reason',
    TOGGLE_SUPER_UNBAN = '[unbanForm] toggle super unban',
    PRESS_UNBAN = '[unbanForm] press unban',
    DECLINE = '[unbanForm] decline',
    UNBAN = '[unbanForm] unban',
    UNBAN_SUCCESS = '[unbanForm] unban success',
    UNBAN_ERROR = '[unbanForm] unban error'
}

export interface IUnbanPayload {
    examsForUnban: string[],
    userLogin: string,
    reason: string,
    isSuperUnban: boolean
}

interface IExamsPayload {
    exams: string[]
}

export interface IChooseExamsAction extends Action<IExamsPayload> {
    type: ActionTypes.CHOOSE_EXAMS,
    payload: IExamsPayload
}

export interface ITypeLoginAction extends Action<ITypePayload> {
    type: ActionTypes.TYPE_LOGIN,
    payload: ITypePayload
}

export interface ITypeReasonAction extends Action<ITypePayload> {
    type: ActionTypes.TYPE_REASON,
    payload: ITypePayload
}

export interface IToggleSuperUnbanAction extends Action<null> {
    type: ActionTypes.TOGGLE_SUPER_UNBAN
}

export interface IPressUnbanAction extends Action<null> {
    type: ActionTypes.PRESS_UNBAN
}

export interface IDeclineAction extends Action<null> {
    type: ActionTypes.DECLINE
}

export interface IUnbanAction extends Action<IUnbanPayload> {
    type: ActionTypes.UNBAN,
    payload: IUnbanPayload
}

export interface IUnbanSuccessAction extends Action<null> {
    type: ActionTypes.UNBAN_SUCCESS
}

export interface IUnbanErrorAction extends Action<IDetailsError> {
    type: ActionTypes.UNBAN_ERROR,
    payload: IDetailsError
}

export type UnbanFormAction =
    | IChooseExamsAction
    | ITypeLoginAction
    | ITypeReasonAction
    | IToggleSuperUnbanAction
    | IUnbanAction
    | IUnbanSuccessAction
    | IUnbanErrorAction
    | IPressUnbanAction
    | IDeclineAction;

export type UnbanFormPayload =
    | IExamsPayload
    | ITypePayload
    | IUnbanPayload
    | IDetailsError;
