import {
    ActionTypes,
    ITypeAttemptIdAction,
    IFocusAttemptIdAction,
    IBlurAttemptIdAction,
    IGetVideosAction,
    IGetVideosSuccessAction,
    IGetVideosErrorAction,
    IDecideAction,
    ITypeEmailAction,
    IFocusEmailAction,
    IBlurEmailAction,
    IPressSendAction,
    IConfirmAction,
    IDeclineAction,
    ISubmitSuccessAction,
    ISubmitErrorAction,
    VerdictType,
    IVideosError,
    IGetVideosSuccessPayload
} from './types';

export function typeAttemptIdAction(inputText: string): ITypeAttemptIdAction {
    return { type: ActionTypes.TYPE_ATTEMPT_ID, payload: { inputText } };
}

export function focusAttemptId(): IFocusAttemptIdAction {
    return { type: ActionTypes.FOCUS_ATTEMPT_ID };
}

export function blurAttemptId(): IBlurAttemptIdAction {
    return { type: ActionTypes.BLUR_ATTEMPT_ID };
}

export function getVideos(attemptId: string): IGetVideosAction {
    return { type: ActionTypes.GET_VIDEOS, payload: { attemptId } };
}

export function getVideosSuccess(videosData: IGetVideosSuccessPayload): IGetVideosSuccessAction {
    const { videos, appealData, pdfLink, additionalInfo } = videosData;

    return {
        type: ActionTypes.GET_VIDEOS_SUCCESS,
        payload: { videos, appealData, pdfLink, additionalInfo }
    };
}

export function getVideosError(error: IVideosError): IGetVideosErrorAction {
    return { type: ActionTypes.GET_VIDEOS_ERROR, payload: error };
}

export function decide(verdict: VerdictType): IDecideAction {
    return { type: ActionTypes.DECIDE, payload: { verdict } };
}

export function typeEmailAction(inputText: string): ITypeEmailAction {
    return { type: ActionTypes.TYPE_EMAIL, payload: { inputText } };
}

export function focusEmail(): IFocusEmailAction {
    return { type: ActionTypes.FOCUS_EMAIL };
}

export function blurEmail(): IBlurEmailAction {
    return { type: ActionTypes.BLUR_EMAIL };
}

export function showConfirmation(): IPressSendAction {
    return { type: ActionTypes.PRESS_SEND };
}

export function confirm(attemptId: string, verdict: VerdictType, email: string): IConfirmAction {
    return { type: ActionTypes.CONFIRM, payload: { attemptId, verdict, email } };
}

export function decline(): IDeclineAction {
    return { type: ActionTypes.DECLINE };
}

export function submitSuccess(): ISubmitSuccessAction {
    return { type: ActionTypes.SUBMIT_SUCCESS };
}

export function submitError(error: IVideosError): ISubmitErrorAction {
    return { type: ActionTypes.SUBMIT_ERROR, payload: error };
}
