import { all, call, takeLatest, put } from 'redux-saga/effects';

import { serverUrls } from '../../../common/server-urls';

import fetch from '../../common/fetch';

import {
    ActionTypes,
    IConfirmAction,
    IGetVideosAction,
    IGetVideosSuccessPayload
} from './types';

import { getVideosSuccess, getVideosError, submitSuccess, submitError } from './actions';

function *getVideos(action: IGetVideosAction) {
    try {
        const { attemptId } = action.payload;

        const url = serverUrls.attemptVideos.build({ attemptId });

        const res: IGetVideosSuccessPayload = yield call(fetch, url, { method: 'GET' });

        const { videos, appealData, pdfLink, additionalInfo } = res;

        yield put(getVideosSuccess({ videos, appealData, pdfLink, additionalInfo }));
    } catch (err) {
        yield put(getVideosError(err.data || err));
    }
}

function *submit(action: IConfirmAction) {
    try {
        const { attemptId, verdict, email } = action.payload;

        yield call(fetch, serverUrls.appeal.build(), {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ attemptId, verdict, email })
        });

        yield put(submitSuccess());
    } catch (err) {
        yield put(submitError(err.data || err));
    }
}

export default function *() {
    yield all([
        takeLatest(ActionTypes.GET_VIDEOS, getVideos),
        takeLatest(ActionTypes.CONFIRM, submit)
    ]);
}
