import { Action } from 'redux-actions'; // eslint-disable-line import/named

import { ITypePayload } from '../common/types';
import RequestStatus from '../../../common/types/requestStatus';

export type VerdictType = string | null;

export interface IVideosError {
    internalCode: string,
    message: string
}

export interface IAppealDataFromDB {
    verdict?: string,
    certId?: number
}

export interface ITolokaAnswer {
    violations: boolean,
    noVioAudioProblems: boolean,
    noVioNoRelate: boolean,
    noVioOther: boolean,
    noVioOtherText: null,
    noVioVideoProblems: boolean,
    vioCheating: boolean,
    vioDiffUser: boolean,
    vioOther: boolean,
    vioOtherPeople: boolean,
    vioOtherText: null,
    vioTips: boolean,
    vioWalkAwayScreen: boolean
}

export interface IAdditionalInfo {
    start: number,
    end: number,
    hasViolations: boolean,
    answers: ITolokaAnswer[]
}

export interface IProctoringResponsesInfo {
    source: string,
    additionalInfo: IAdditionalInfo[]
}

export interface IVideosState {
    attemptId: string,
    hasFocusAttemptId: boolean,
    isValidAttemptId: boolean,
    hasAttemptId: boolean,
    videos: string[],
    verdict: VerdictType,
    email: string,
    hasFocusEmail: boolean,
    isValidEmail: boolean,
    isSubmitError: boolean,
    hasEmail: boolean,
    requestStatus: RequestStatus | null,
    requestError: IVideosError | null,
    isVisibleConfirmationModal: boolean,
    isAppealSuccess: boolean,
    appealDataFromDB: IAppealDataFromDB | null,
    pdfLink: string,
    proctoringResponsesInfo: IProctoringResponsesInfo[] | null
}

export enum ActionTypes {
    TYPE_ATTEMPT_ID = '[videos] type attempt id',
    FOCUS_ATTEMPT_ID = '[videos] focus attempt id',
    BLUR_ATTEMPT_ID = '[videos] blur attempt id',
    GET_VIDEOS = '[videos] get videos',
    GET_VIDEOS_SUCCESS = '[videos] get videos success',
    GET_VIDEOS_ERROR = '[videos] get videos error',
    DECIDE = '[videos] decide',
    TYPE_EMAIL = '[videos] type email',
    FOCUS_EMAIL = '[videos] focus email',
    BLUR_EMAIL = '[videos] blur email',
    PRESS_SEND = '[videos] press send',
    CONFIRM = '[videos] confirm',
    DECLINE = '[videos] decline',
    SUBMIT_SUCCESS = '[videos] submit success',
    SUBMIT_ERROR = '[videos] submit error'
}

export interface ITypeAttemptIdAction extends Action<ITypePayload> {
    type: ActionTypes.TYPE_ATTEMPT_ID,
    payload: ITypePayload
}

export interface IFocusAttemptIdAction extends Action<null> {
    type: ActionTypes.FOCUS_ATTEMPT_ID
}

export interface IBlurAttemptIdAction extends Action<null> {
    type: ActionTypes.BLUR_ATTEMPT_ID
}

export interface IGetVideosPayload {
    attemptId: string
}

export interface IGetVideosAction extends Action<IGetVideosPayload> {
    type: ActionTypes.GET_VIDEOS,
    payload: IGetVideosPayload
}

export interface IGetVideosSuccessPayload {
    videos: string[],
    appealData: IAppealDataFromDB,
    pdfLink: string,
    additionalInfo: IProctoringResponsesInfo[]
}

export interface IGetVideosSuccessAction extends Action<IGetVideosSuccessPayload> {
    type: ActionTypes.GET_VIDEOS_SUCCESS,
    payload: IGetVideosSuccessPayload
}

export interface IGetVideosErrorAction extends Action<IVideosError> {
    type: ActionTypes.GET_VIDEOS_ERROR,
    payload: IVideosError
}

interface IVerdict {
    verdict: VerdictType
}

export interface IDecideAction extends Action<IVerdict> {
    type: ActionTypes.DECIDE,
    payload: IVerdict
}

export interface ITypeEmailAction extends Action<ITypePayload> {
    type: ActionTypes.TYPE_EMAIL,
    payload: ITypePayload
}

export interface IFocusEmailAction extends Action<null> {
    type: ActionTypes.FOCUS_EMAIL
}

export interface IBlurEmailAction extends Action<null> {
    type: ActionTypes.BLUR_EMAIL
}

export interface IPressSendAction extends Action<null> {
    type: ActionTypes.PRESS_SEND
}

interface IConfirmPayload {
    attemptId: string,
    verdict: VerdictType,
    email: string
}

export interface IConfirmAction extends Action<IConfirmPayload> {
    type: ActionTypes.CONFIRM,
    payload: IConfirmPayload
}

export interface IDeclineAction extends Action<null> {
    type: ActionTypes.DECLINE
}

export interface ISubmitSuccessAction extends Action<null> {
    type: ActionTypes.SUBMIT_SUCCESS
}

export interface ISubmitErrorAction extends Action<IVideosError> {
    type: ActionTypes.SUBMIT_ERROR,
    payload: IVideosError
}

export type VideosAction =
    | ITypeAttemptIdAction
    | IFocusAttemptIdAction
    | IBlurAttemptIdAction
    | IGetVideosAction
    | IGetVideosSuccessAction
    | IGetVideosErrorAction
    | IDecideAction
    | ITypeEmailAction
    | IFocusEmailAction
    | IBlurEmailAction
    | IPressSendAction
    | IConfirmAction
    | IDeclineAction
    | ISubmitSuccessAction
    | ISubmitErrorAction;

export type VideosPayload =
    | ITypePayload
    | IGetVideosPayload
    | IGetVideosSuccessPayload
    | IVideosError
    | IVerdict
    | IConfirmPayload;
