import config from 'yandex-cfg';

import { Url } from './utils/url';

export const apiUrls = {
    freeze: new Url(`${config.api.pathname}/admin/freeze`),
    unfreeze: new Url(`${config.api.pathname}/admin/unfreeze`),
    syncAgenciesInfo: new Url(`${config.api.pathname}/admin/syncAgenciesInfo`),
    parseXLSX: new Url(`${config.api.pathname}/admin/parseXLSX`),
    loadData: new Url(`${config.api.pathname}/admin/loadData`),
    videos: new Url(`${config.api.pathname}/admin/videos`),
    appeal: new Url(`${config.api.pathname}/admin/appeal`),
    downloadJSON: new Url(`${config.api.pathname}/admin/downloadJSON/:examIdentity`),
    examSettings: new Url(`${config.api.pathname}/exam/:examIdentity/settings`),
    report: new Url(`${config.api.pathname}/admin/report/:reportType`),
    getAttemptsInfo: new Url(`${config.api.pathname}/attempt/info`),
    getCertificatesInfo: new Url(`${config.api.pathname}/certificates/info`),
    nullifyAttempt: new Url(`${config.api.pathname}/admin/attempts/nullify`),
    nullifyCertificates: new Url(`${config.api.pathname}/certificates/nullify`),
    getAssociationsInfo: new Url(`${config.api.pathname}/admin/user/associations`),
    associateUsers: new Url(`${config.api.pathname}/user/associate`),
    ban: new Url(`${config.api.pathname}/user/ban`),
    unban: new Url(`${config.api.pathname}/user/unban`),
    lock: new Url(`${config.api.pathname}/exam/:examIdentity/lock`),
    unlock: new Url(`${config.api.pathname}/exam/:examIdentity/unlock`),
    lastVersion: new Url(`${config.api.pathname}/exam/:examIdentity/lastVersion`),
    draft: new Url(`${config.api.pathname}/exam/:examIdentity/draft`),
    draftModeration: new Url(`${config.api.pathname}/admin/moderation/exam`)
};
