import { Url } from './utils/url';

export const serverUrls = {
    root: new Url('/'),
    admin: new Url('/admin'),
    dev: new Url('/dev'),
    nullify: new Url('/nullify'),
    banPage: new Url('/bans'),
    freeze: new Url('/freeze'),
    unfreeze: new Url('/unfreeze'),
    syncAgenciesInfo: new Url('/syncAgenciesInfo'),
    upload: new Url('/upload'),
    publishExam: new Url('/exam/publish'),
    videos: new Url('/videos'),
    appeal: new Url('/appeal'),
    attemptVideos: new Url('/videos/:attemptId'),
    exam: new Url('/admin/:examIdentity'),
    examSettings: new Url('/exam/:examIdentity/settings'),
    downloadJSON: new Url('/exam/:examIdentity/downloadJSON'),
    lockExam: new Url('/exam/:examIdentity/lock'),
    unlockExam: new Url('/exam/:examIdentity/unlock'),
    lastVersion: new Url('/exam/:examIdentity/lastVersion'),
    report: new Url('/admin/report/:reportType'),
    getAttemptsInfo: new Url('/getAttemptsInfo'),
    getCertificatesInfo: new Url('/getCertificatesInfo'),
    nullifyAttempt: new Url('/attempt/nullify'),
    nullifyCertificates: new Url('/certificates/nullify'),
    getAssociationsInfo: new Url('/admin/user/associations'),
    associateUsers: new Url('/user/associate'),
    ban: new Url('/user/ban'),
    unban: new Url('/user/unban'),
    draft: new Url('/exam/:examIdentity/draft'),
    draftModeration: new Url('/admin/moderation/exam')
};
