import Dictionary from './dictionary';

export enum Roles {
    analyst = 'analyst',
    developer = 'developer',
    admin = 'admin',
    assessor = 'assessor',
    editor = 'editor',
    support = 'support'
}

type LockedExam = {
    [examSlug: string]: {
        lockDate: string,
        login: string
    }
};

export type AdminData = {
    lastSyncAgenciesDate: string,
    currentFrozenExams: string[],
    lockedExams: LockedExam,
    userRoles: Roles[],
    accessToPages: Dictionary<boolean>
};
