export interface IExamEditable {
    isNew: boolean,
    isChanged: boolean,
    isRemoved: boolean
}

export type TEditAnswer = IExamEditable & {
    id: number,
    text: string,
    correct: number,
    active: number
};

export interface IEditAnswers {
    [key: number]: TEditAnswer
}

export type TEditQuestion = IExamEditable & {
    id: number,
    text: string,
    type: number,
    active: number,
    answers: IEditAnswers
};

export interface IEditQuestions {
    [key: number]: TEditQuestion
}

export type TEditCategory = IExamEditable & {
    id: number,
    quantity: number,
    questions: IEditQuestions
};

export interface IEditCategories {
    [key: number]: TEditCategory
}

export type TEditSection = IExamEditable & {
    allowedFails: number,
    title: string,
    code: string,
    serviceId: number,
    categories: IEditCategories
};

interface IEditTestData {
    [key: string]: TEditSection
}

export default IEditTestData;
