import Dictionary from './dictionary';

export interface IErrorCode {
    text: string,
    fields?: string[]
}

const ERROR_CODES: Dictionary<IErrorCode> = {
    default: {
        text: 'Произошла ошибка.'
    },
    '400_PFD': {
        text: 'Неподдерживаемый формат файла.'
    },
    '400_WCA': {
        text: 'Некорректное количество правильных ответов в вопросе.',
        fields: ['questionText']
    },
    '400_ICN': {
        text: 'Некорректное название столбца.',
        fields: ['columnName']
    },
    '400_IVT': {
        text: 'Тип значения в ячейке не соответствует типу столбца.',
        fields: ['columnName', 'value', 'rowNumber']
    },
    '400_DIA': {
        text: 'Остутствует блок данных.',
        fields: ['schema']
    },
    '400_TLI': {
        text: 'Невалидная длительность теста',
        fields: ['timeLimit']
    },
    '400_FNS': {
        text: 'Некорректное значение поля',
        fields: ['title', 'description', 'rules', 'seoDescription', 'ogDescription']
    },
    '400_CSF': {
        text: 'Невалидный черновик'
    },
    '400_CSA': {
        text: 'Некорректные id сертификатов'
    },
    '400_CII': {
        text: 'Некорректный id сертификата',
        fields: ['certId']
    },
    '400_ASA': {
        text: 'Некорректные id попыток'
    },
    '400_AII': {
        text: 'Некорректный id попытки',
        fields: ['attemptId']
    },
    '401_UNA': {
        text: 'Пользователь не авторизован.'
    },
    '403_NAD': {
        text: 'Пользователь не админ.'
    },
    '403_UNS': {
        text: 'Пользователь не является админом или саппортом.'
    },
    '403_AAM': {
        text: 'Апелляция по данной попытке уже была проведена.'
    },
    '403_EAE': {
        text: 'Тест уже заблокирован на редактирование.',
        fields: ['login']
    },
    '404_ENF': {
        text: 'Экзамен не найден.',
        fields: ['id']
    },
    '404_QNF': {
        text: 'Вопрос не найден.',
        fields: ['id']
    },
    '404_ANF': {
        text: 'Ответ не найден.',
        fields: ['id']
    },
    '404_ATF': {
        text: 'Попытка не найдена.'
    },
    '404_VNF': {
        text: 'Нет сохраненных видео для данной попытки.'
    },
    '404_TNF': {
        text: 'Тест не найден'
    },
    '404_UNF': {
        text: 'Пользователь не найден.',
        fields: ['login']
    },
    '404_SUN': {
        text: 'Некоторые пользователи не найдены.',
        fields: ['logins']
    },
    '500_NMC': {
        text: 'Некорректные данные в файле.'
    }
};

export default ERROR_CODES;
