import ERROR_CODES from 'common/types/errorCodes';

interface IAPIError {
    url: string,
    status: number,
    statusText: string,
    data: any
}

export class BaseError extends Error {
    public readonly code: string;

    public constructor(code: string) {
        super();
        this.code = code;

        Object.setPrototypeOf(this, new.target.prototype);
    }
}

export class APIError extends BaseError implements IAPIError {
    public readonly url: string;
    public readonly status: number;
    public readonly statusText: string;
    public readonly data: any;

    public constructor(code: string, error: IAPIError) {
        super(code);
        this.url = error.url;
        this.status = error.status;
        this.statusText = error.statusText;
        this.data = error.data;
    }
}

type ErrorDetails = {
    message: string,
    details: string
};

export interface IDetailsError {
    internalCode: string,
    message: string,
    [key:string]: string | number
}

export function getDetailedError(error: IDetailsError): ErrorDetails {
    const { internalCode } = error;
    const errorHandler = ERROR_CODES[internalCode] || ERROR_CODES.default;
    const errorFields = errorHandler.fields || [];

    const details = errorFields
        .map((field: string) => {
            return `${field}: ${error[field]}`;
        })
        .join(', ');

    return { message: errorHandler.text, details };
}
