import { join } from 'path';

import { AppConfig } from 'yandex-cfg';
import defaultPreset from '@yandex-int/yandex-logger/middleware/preset-default';
import deployStream from '@yandex-int/yandex-logger/streams/deploy';

import { Roles } from '../common/types/adminData';

import defaultsCsp from './csp/defaults';

const config: AppConfig = {
    blackbox: {
        retries: 1,
        timeout: 200,
        api: 'blackbox.yandex-team.ru'
    },

    defaultAvatarSrc: '0/0-0',

    csp: {
        presets: defaultsCsp,
        policies: {
            'media-src': ['yastatic.net']
        },
        serviceName: 'expert-office',
        useDefaultReportUri: true
    },

    httpGeobase: {
        server: 'http://geobase.qloud.yandex.ru',
        clientOptions: {
            timeout: 100
        }
    },

    httpLangdetect: {
        server: 'http://langdetect.qloud.yandex.ru',
        clientOptions: {
            timeout: 100
        },
        defaultLanguage: 'ru',
        availableLanguages: ['ru']
    },

    httpUatraits: {
        server: 'http://uatraits.qloud.yandex.ru',
        clientOptions: {
            timeout: 100
        }
    },

    langs: ['ru'],

    logger: {
        fields: {
            environment: process.env.NODE_ENV,
            release: process.env.APP_VERSION
        },
        middleware: [
            defaultPreset()
        ],
        name: 'expert-office',
        streams: [
            {
                level: 'info',
                stream: deployStream()
            }
        ]
    },

    static: {
        dir: join(__dirname, '..', 'client'),
        staticDir: join(__dirname, '..', '..', 'static')
    },

    render: {
        isHot: false
    },

    tvm: {
        destinations: ['blackbox'],
        serverUrl: process.env.DEPLOY_TVM_TOOL_URL,
        token: process.env.TVMTOOL_LOCAL_AUTHTOKEN
    },

    api: {
        protocol: 'http',
        pathname: '/v1',
        reportPath: '/admin/report'
    },

    exams: [
        { id: 1, slug: 'direct', title: 'Сертификация специалистов по Яндекс.Директу' },
        { id: 4, slug: 'metrika', title: 'Сертификация специалистов по Яндекс.Метрике' },
        {
            id: 37,
            slug: 'hello',
            title: 'Алгеброй гармонию проверил: тест для знакомства с интерфейсом'
        },
        { id: 38, slug: 'direct-en', title: 'Yandex.Direct certification' },
        { id: 39, slug: 'metrica-en', title: 'Become a Yandex.Metrica certified specialist' },
        { id: 40, slug: 'direct-cn', title: 'Yandex.Direct专家测试' },
        { id: 41, slug: 'market', title: 'Сертификация специалистов по Яндекс.Маркету' },
        { id: 42, slug: 'publisher', title: 'Сертификация специалистов по AdFox' },
        { id: 43, slug: 'rsya', title: 'Сертификация специалистов по РСЯ' },
        { id: 44, slug: 'direct-pro', title: 'Сертификация по Яндекс.Директу с прокторингом' },
        { id: 45, slug: 'cpm', title: 'Тестирование по медийной рекламе Яндекса' },
        { id: 46, slug: 'zen', title: 'Сертификация специалистов по Яндекс.Дзену' },
        { id: 47, slug: 'msp', title: 'Тест на понимание основ продвижения бизнеса в интернете' },
        { id: 48, slug: 'direct-base', title: 'Сертификация по Яндекс.Директу (тестирование)' },
        { id: 49, slug: 'market-base', title: 'Сертификация по Яндекс Маркету (тестирование)' },
        { id: 50, slug: 'rmp', title: 'Сертификация по рекламе приложений' }
    ],

    intervals: {
        '1d': '1 день',
        '1w': '1 неделя',
        '1m': '1 месяц',
        '3m': '3 месяца',
        '1y': '1 год'
    },

    pageToRoles: {
        reports: [Roles.analyst, Roles.assessor, Roles.support],
        admin: [Roles.admin, Roles.editor],
        exam: [Roles.admin, Roles.editor],
        dev: [Roles.developer],
        videos: [Roles.admin, Roles.assessor, Roles.support],
        nullify: [Roles.admin, Roles.support],
        bans: [Roles.admin, Roles.support]
    }
};

module.exports = config;
