import { AppConfig } from 'yandex-cfg';
import lineStream from 'yandex-logger/streams/line';

import localCsp from './csp/local';

const config: AppConfig = {
    csp: {
        presets: localCsp
    },

    httpGeobase: {
        server: 'http://geobase-test.qloud.yandex.ru'
    },

    httpLangdetect: {
        server: 'http://langdetect-test.qloud.yandex.ru'
    },

    httpUatraits: {
        server: 'http://uatraits-test.qloud.yandex.ru'
    },

    langs: ['ru'],

    logger: {
        streams: [
            {
                level: 'info',
                stream: lineStream({
                    template: [
                        '{{date}}',
                        '{{levelName}}',
                        '{{msg}}',
                        '{{#err}}\n{{err.stack}}{{/err}}'
                    ].join(' ')
                })
            }
        ]
    },

    render: {
        isHot: true
    },

    static: {
        baseUrl: '/static',
        frozenPath: '/_',
        version: ''
    },

    tvm: {
        destinations: [],
        serverUrl: 'http://localhost:8001',
        token: 'tvmtool-development-access-token'
    },

    api: {
        host: 'expert-api-office-dev.commerce-int.yandex-team.ru'
    },

    defaultIp: '37.140.187.23', // Ip Яндекса для локальной разработки, если не работает, указать свой

    exams: [
        { id: 1, slug: 'direct', title: 'Сертификация специалистов по Яндекс.Директу' },
        { id: 4, slug: 'metrika', title: 'Сертификация специалистов по Яндекс.Метрике' },
        { id: 22, slug: 'simple-cn', title: 'Yandex.Simple (China)' },
        { id: 25, slug: 'vip', title: 'Сертификация VIP PROCTORING' },
        { id: 35, slug: 'hello-pro', title: 'Hello c прокторингом' },
        {
            id: 37,
            slug: 'hello',
            title: 'Алгеброй гармонию проверил: тест для знакомства с интерфейсом'
        },
        { id: 38, slug: 'direct-en', title: 'Yandex.Direct certification' },
        { id: 39, slug: 'metrica-en', title: 'Become a Yandex.Metrica certified specialist' },
        { id: 40, slug: 'direct-cn', title: 'Yandex.Direct专家测试' },
        { id: 41, slug: 'market', title: 'Сертификация специалистов по Яндекс.Маркету' },
        { id: 42, slug: 'publisher', title: 'Сертификация специалистов по AdFox' },
        { id: 43, slug: 'rsya', title: 'Сертификация специалистов по РСЯ' },
        { id: 44, slug: 'direct-pro', title: 'Сертификация по Яндекс.Директу с прокторингом' },
        { id: 45, slug: 'cpm', title: 'Тестирование по медийной рекламе Яндекса' },
        { id: 46, slug: 'zen', title: 'Сертификация специалистов по Яндекс.Дзену' },
        { id: 47, slug: 'msp', title: 'Тест на понимание основ продвижения бизнеса в интернете' }
    ]
};

module.exports = config;
