import express from 'express';

import router from 'server/router';
import { finalErrorHandler, render, logger } from 'server/middlewares';
import morgan from 'morgan';

require('debug-http')();

const app = express();

app
    .disable('x-powered-by')
    .enable('trust proxy')
    .use(morgan('combined'))
    .use(render)
    .use(logger)
    .use(router)
    .use(finalErrorHandler);

export default app;
