import Dictionary from 'common/types/dictionary';
import IExam from 'common/types/exam';

import BaseController from './base';

class BanController extends BaseController {
    public banPage() {
        const {
            base: { exams },
            adminData
        } = this.req;

        const examsById = exams.reduce((acc: Dictionary<string>, exam: IExam) => {
            const { id, slug } = exam;

            acc[id] = slug;

            return acc;
        }, {});

        this.render({
            adminData,
            examsById
        });
    }
}

export default BanController.getAction('banPage');
