import _ from 'lodash';

import Dictionary from '../../common/types/dictionary';
import IExam from '../../common/types/exam';

import BaseController from './base';

class DevController extends BaseController {
    public devPage() {
        const {
            base: { exams },
            adminData
        } = this.req;

        const examsIds = _.map(exams, 'id');
        const frozenExamsIds = _.map(adminData.currentFrozenExams, 'trialTemplateId');
        const availableForFreezeExams = _.difference(examsIds, frozenExamsIds);

        const examsById = exams.reduce((acc: Dictionary<string>, exam: IExam) => {
            const { id, slug } = exam;

            acc[id] = slug;

            return acc;
        }, {});

        this.render({
            frozenExams: frozenExamsIds,
            availableForFreezeExams,
            examsById,
            adminData
        }, {
            freeze: {
                frozenExams: frozenExamsIds,
                availableForFreezeExams,
                examsForFreeze: [],
                examsForUnfreeze: []
            }
        });
    }
}

export default DevController.getAction('devPage');
