import ExamModel from 'server/models/exam';

import BaseController from 'server/controllers/base';

import { initialState } from 'client/store/examData/reducer';

class ExamController extends BaseController {
    public async examPage() {
        const { adminData } = this.req;

        const examModel = new ExamModel(this.req, this.res);
        const exam = await examModel.fetch();
        const draftStatus = await examModel.getDraftStatus(exam.id);

        this.render({ exam, adminData }, {
            editExamForm: exam,
            examData: { ...initialState, draftStatus }
        });
    }
}

export default ExamController.getAction('examPage');
