import url from 'url';

import config from 'yandex-cfg';
import _ from 'lodash';

import ReportsModel from '../models/reports';

import Dictionary from '../../common/types/dictionary';

import BaseController from './base';

const { api, intervals } = config;

const formatReportUrl = (reportPath: string): string => url.format({
    pathname: `/admin/report/${reportPath}`,
    query: {
        format: 'xlsx'
    }
});

class ReportController extends BaseController {
    public async reportPage() {
        const reportsModel = new ReportsModel(this.req, this.res);
        const reports = await reportsModel.fetch();

        const reportTypes = reports.map(report => report.type);

        const reportsUrls = _.transform(reportTypes, (res: Dictionary<string>, type: string) => {
            res[type] = formatReportUrl(type);
        }, {});

        const { adminData } = this.req;

        this.render({
            reportsUrls,
            reportTypes,
            agenciesStatUrl: url.format({
                protocol: api.protocol,
                host: api.host,
                pathname: `${api.pathname}/admin/agenciesInfo`
            }),
            intervals,
            adminData
        });
    }
}

export default ReportController.getAction('reportPage');
