import { NextFunction, Request, Response } from 'express';
import _ from 'lodash';

import config from 'yandex-cfg';

import InfoModel from '../models/info';
import Dictionary from '../../common/types/dictionary';
import { Roles } from '../../common/types/adminData';

const getAccessToPages = (userRoles: Roles[]): Dictionary<boolean> => {
    const { pageToRoles } = config;

    return _.mapValues(pageToRoles, roles => _.intersection(roles, userRoles).length > 0);
};

export default function (page: string) {
    return async function (req: Request, res: Response, next: NextFunction): Promise<void> {
        const infoModel = new InfoModel(req, res);

        try {
            const {
                lastSyncAgenciesDate,
                currentFrozenExams,
                lockedExams,
                access: userRoles
            } = await infoModel.fetch();

            const accessToPages = getAccessToPages(userRoles);

            if (!accessToPages[page]) {
                throw new Error('Page is not available');
            }

            req.adminData = {
                lastSyncAgenciesDate,
                currentFrozenExams,
                lockedExams,
                userRoles,
                accessToPages
            };

            next();
        } catch (err) {
            req.logger.error(err);

            res.sendStatus(404);
        }
    };
}
