import url from 'url';

import { NextFunction, Request, Response } from 'express';
import config from 'yandex-cfg';

export default function () {
    return (req: Request, _res: Response, next: NextFunction) => {
        if (!req.blackbox) {
            next();

            return;
        }

        const { login = '' } = req.blackbox.raw;

        req.base = {
            userInfo: {
                staff: `https://staff.yandex-team.ru/${login}`,
                avatar: `https://center.yandex-team.ru/api/v1/user/${login}/avatar/32.jpg`,
                login
            },
            exams: config.exams,
            api: url.format({
                protocol: 'https',
                hostname: config.api.host,
                pathname: config.api.pathname
            })
        };

        next();
    };
}
