import { Request, Response, NextFunction } from 'express';

import renderBundle from './render-bundle';

export default (req: Request, res: Response, next: NextFunction) => {
    res.renderBundle = (bundleName, data, state) => {
        const lang = req.langdetect.id;
        const location = req.url;
        const { html, redirectUrl } = renderBundle({ bundleName, data, state, lang, location });

        if (redirectUrl) {
            res.redirect(redirectUrl);

            return;
        }

        res.send(html);
    };

    next();
};
