import _ from 'lodash';

import IExamSettings from 'common/types/examSettings';
import DraftStatus from 'common/types/draftStatus';

import BaseModel from 'server/models/base';

type GetDraftStatusPayload = DraftStatus | null;

class Exam extends BaseModel {
    public get examIdentity(): string {
        return _.get(this._req, 'params.examIdentity');
    }

    private parseInfo(data: any): IExamSettings {
        return _.pick(data, [
            'id',
            'slug',
            'timeLimit',
            'title',
            'language',
            'rules',
            'description',
            'seoDescription',
            'ogDescription'
        ]);
    }

    public async fetch(): Promise<any> {
        const options = { url: `/exam/${this.examIdentity}` };

        const data = await this._request<any>(options);

        return this.parseInfo(data);
    }

    public async getDraftStatus(examId: number): Promise<GetDraftStatusPayload> {
        const options = { url: `/exam/${examId}/draft` };

        const data = await this._request<any>(options);

        return _.get(data, 'status', null);
    }
}

export default Exam;
