import { Router } from 'express';

import blackboxHealthcheck from 'server/controllers/healthchecks/blackbox';
import tvmHealthcheck from 'server/controllers/healthchecks/tvm';
import pingHealthcheck from 'server/controllers/healthchecks/ping';

import {
    blackbox,
    cookieParser,
    logger,
    tvm
} from '../middlewares';

const healthchecksRouter: Router = Router();

healthchecksRouter
    .get('/blackbox', [logger, cookieParser, tvm, blackbox], blackboxHealthcheck)
    .get('/tvm', [logger, tvm], tvmHealthcheck)
    .get('/ping', logger, pingHealthcheck);

export default function (appRouter: Router) {
    appRouter.use('/healthchecks', healthchecksRouter);
}
