import { Agent } from 'http';

import Dictionary from 'common/types/dictionary';

export interface IRequestOptionsHeaders extends Dictionary<any> {
    userhost: string,
    userip: string,
    cookie: string | string[],
    'accept-encoding': string,
    'content-type': string
}

export interface IRequestOptions {
    url: string,
    query?: Dictionary<string>,
    json?: boolean,
    agent?: Agent,
    retries?: 0,
    headers?: IRequestOptionsHeaders,
    body?: any
}

export interface IRequestParams {
    options: IRequestOptions,
    url: string
}

export type IAttributes = any;
