/* eslint complexity: 0 */

import { join } from 'path';

import cfg from 'yandex-cfg';
import webpack from 'webpack';
import MiniCssExtractPlugin from 'mini-css-extract-plugin';
import ForkTsCheckerPlugin from 'fork-ts-checker-webpack-plugin';
import ForkTsCheckerNotifierPlugin from 'fork-ts-checker-notifier-webpack-plugin';
import { TsconfigPathsPlugin } from 'tsconfig-paths-webpack-plugin';

import * as loaders from './loaders';
import { CLIENT_DIR, DIST_DIR, ROOT_DIR } from './dir';
import { IS_DEV, ENV } from './env';
import { STATS_OPTIONS } from './config';

const vendorsManifest = require(join(DIST_DIR, 'webpack-configs', 'vendors-manifest.json'));

function getConfig(lang: string, index: number): webpack.Configuration {
    // Т.к. все сборки отличаются только переводами, то проверять типы можно только один раз
    const shouldCheckTypes = index === 0;

    return {
        name: `client_${lang}`,
        target: 'web',
        devtool: 'source-map',
        entry: {
            desktop: [
                IS_DEV && 'css-hot-loader/hotModuleReplacement',
                IS_DEV && `webpack-hot-middleware/client?path=/__webpack_hmr_${index}`,
                join(CLIENT_DIR, 'bundles', 'desktop')
            ].filter(Boolean) as string[]
        },
        output: {
            filename: `[name].bundle.${lang}.js`,
            library: 'Client',
            libraryTarget: 'var',
            path: join(DIST_DIR, 'client'),
            publicPath: '/static/'
        },
        module: {
            rules: [
                loaders.legoI18N,
                loaders.css.client,
                loaders.typescript.client,
                loaders.file.client,
                loaders.url,
                loaders.svg.client
            ]
        },
        resolve: {
            extensions: ['.js', '.ts', '.tsx'],
            plugins: [
                new TsconfigPathsPlugin()
            ]
        },
        plugins: [
            new webpack.DllReferencePlugin({
                context: ROOT_DIR,
                manifest: vendorsManifest
            }),
            new MiniCssExtractPlugin({
                filename: '[name].bundle.css'
            }),
            new webpack.DefinePlugin({
                'process.env.NODE_ENV': JSON.stringify(ENV),
                'process.env.BEM_LANG': JSON.stringify(lang)
            }),
            shouldCheckTypes && new ForkTsCheckerPlugin({
                watch: IS_DEV ? [CLIENT_DIR] : undefined
            }),
            shouldCheckTypes && new ForkTsCheckerNotifierPlugin({
                excludeWarnings: true,
                skipSuccessful: true
            }),
            IS_DEV && new webpack.HotModuleReplacementPlugin()
        ].filter(Boolean) as webpack.Plugin[],
        stats: STATS_OPTIONS
    };
}

export default cfg.langs.map(getConfig);
