import path from 'path';

import autoprefixer from 'autoprefixer';
import cssnano from 'cssnano';
import MiniCssExtractPlugin from 'mini-css-extract-plugin';
import postcssCustomMedia from 'postcss-custom-media';
import postcssCustomProperties from 'postcss-custom-properties';
import postcssFontFamilySystemUi from 'postcss-font-family-system-ui';
import postcssImport from 'postcss-import';
import postcssNested from 'postcss-nested';
import postcssPrependImports from 'postcss-prepend-imports';
import postcssReplaceOverflowWrap from 'postcss-replace-overflow-wrap';
import postcssReporter from 'postcss-reporter';
import webpack from 'webpack';

import { CLIENT_DIR } from '../dir';
import { IS_DEV } from '../env';

const postcssLoader = {
    loader: 'postcss-loader',
    options: {
        plugins: [
            postcssPrependImports({
                path: path.resolve(CLIENT_DIR, 'common'),
                files: ['media.css', 'variables.css']
            }),
            postcssImport(),
            postcssNested(),
            postcssCustomMedia({ preserve: false }),
            postcssCustomProperties({ preserve: false }),
            postcssFontFamilySystemUi(),
            postcssReplaceOverflowWrap(),
            autoprefixer(),
            !IS_DEV && cssnano({ preset: 'default' }),
            postcssReporter()
        ].filter(Boolean)
    }
};

const cssLoader = {
    loader: 'css-loader',
    options: { importLoaders: 1 }
};

export default {
    client: {
        test: /\.css$/,
        use: [
            IS_DEV && 'css-hot-loader',
            MiniCssExtractPlugin.loader,
            cssLoader,
            postcssLoader
        ].filter(Boolean) as webpack.Loader[]
    },

    ssr: {
        loader: 'null-loader',
        test: /\.css$/
    }
};
