import webpack from 'webpack';

import { IS_DEV } from '../env';

export default {
    client: {
        test: /\.tsx?$/,
        exclude: /node_modules/,
        use: [
            IS_DEV && {
                loader: 'babel-loader',
                options: {
                    cacheDirectory: true,
                    plugins: ['react-hot-loader/babel']
                }
            },
            {
                loader: 'ts-loader',
                options: {
                    transpileOnly: true
                }
            }
        ].filter(Boolean) as webpack.Loader[]
    },

    ssr: {
        test: /\.tsx?$/,
        exclude: /node_modules/,
        loader: 'ts-loader',
        options: {
            transpileOnly: true
        }
    }
};
