import { join } from 'path';

import webpack from 'webpack';
import MiniCssExtractPlugin from 'mini-css-extract-plugin';

import { ROOT_DIR_FROM_WEBPACK } from './dir';
import { IS_DEV } from './env';
import { STATS_OPTIONS, VENDORS } from './config';

const DIST_DIR = join(ROOT_DIR_FROM_WEBPACK, 'dist');

const config: webpack.Configuration = {
    target: 'web',
    devtool: 'source-map',
    entry: {
        vendors: VENDORS
    },
    output: {
        library: '[name]_[hash]',
        filename: '[name]_[hash].js',
        path: join(DIST_DIR, 'client', '_')
    },
    plugins: [
        new webpack.DllPlugin({
            name: '[name]_[hash]',
            path: join(DIST_DIR, 'webpack-configs', 'vendors-manifest.json')
        }),
        new MiniCssExtractPlugin({ filename: '[name]_[hash].css' }),
        IS_DEV && new webpack.HotModuleReplacementPlugin()
    ].filter(Boolean) as webpack.Plugin[],
    stats: STATS_OPTIONS
};

export default config;
