package goblogs

import (
	"time"
)

const (
	timeFormat = `"2006-01-02T15:04:05.000Z"`
)

type Time struct {
	time.Time
}

func (t *Time) UnmarshalJSON(b []byte) error {
	parsedTime, err := time.Parse(timeFormat, string(b))

	if err != nil {
		return err
	}

	t.Time = parsedTime

	return nil
}

func (t *Time) MarshalJSON() ([]byte, error) {
	return []byte(t.Format(timeFormat)), nil
}
