package goblogs

type Blog struct {
	ID string `json:"_id"`

	Slug        string `json:"slug"`
	Title       string `json:"title"`
	Description string `json:"description"`
	Image       string `json:"image,omitempty"`
	Type        string `json:"type"`
	ViewType    string `json:"viewType"`

	Language              string   `json:"language"`
	LocaleTimezone        string   `json:"localeTimezone"`
	LanguagesForTranslate []string `json:"langsForTranslate"`

	MaxCommentsLevel uint `json:"maxCommentsLevel"`

	MetaDescription string `json:"metaDescription"`
	MetaKeywords    string `json:"metaKeywords"`

	HasDescription       bool `json:"hasDescription"`
	HasImageTitle        bool `json:"hasImageTitle"`
	HasRelatedArticles   bool `json:"hasRelatedArticles"`
	HasSubscriptionBlock bool `json:"hasSubscriptionBlock"`
	HasTypography        bool `json:"hasTypography"`
	HideShareCount       bool `json:"hideShareCount"`
	ShowAuthor           bool `json:"showAuthor"`
	WithPreview          bool `json:"withPreview"`
	WithSignature        bool `json:"withSignature"`

	IsClosed    bool `json:"isClosed"`
	IsBanned    bool `json:"isBanned"`
	IsModerated bool `json:"isModerated"`
	IsModerator bool `json:"isModerator"`
	IsPrivate   bool `json:"isPrivate"`

	CanComment bool `json:"canComment"`
	CanWrite   bool `json:"canWrite"`

	PostsCount map[string]map[string]uint `json:"postsCount"`

	MetrikaID   string `json:"metrikaId"`
	SaaSPrefix  uint   `json:"prefix"`
	ServiceName string `json:"serviceName"`
	ServiceURL  string `json:"serviceUrl"`

	SocialHeader string       `json:"socialHeader"`
	SocialLinks  []SocialLink `json:"socialLinks"`
}

type SocialLink struct {
	Name string `json:"name"`
	URL  string `json:"url"`
}

type Category struct {
	ID string `json:"_id"`

	ParentID *string `json:"parentCategoryId"`

	Slug        string `json:"slug"`
	DisplayName string `json:"displayName"`
}

type Tag struct {
	Slug        string `json:"slug"`
	DisplayName string `json:"displayName"`
}

type Post struct {
	ID string `json:"_id"`

	AuthorID string `json:"authorId"`

	Slug     string `json:"slug"`
	ViewType string `json:"viewType"`

	ApprovedBody    map[string]string `json:"approvedBody"`
	ApprovedPreview map[string]string `json:"approvedPreview"`
	ApprovedTitle   string            `json:"approvedTitle"`
	RelatedTitle    string            `json:"relatedTitle,omitempty"`

	CommentsCount   uint `json:"commentsCount"`
	CommentsEnabled bool `json:"commentsEnabled,omitempty"`

	CanComment bool `json:"canComment,omitempty"`
	HasNext    bool `json:"hasNext"`
	IsDraft    bool `json:"isDraft"`
	IsOutdated bool `json:"isOutdated"`

	CategoryIDs []string `json:"categoryIds"`
	Tags        []Tag    `json:"tags"`

	SocialImages map[string]Image `json:"socialImage,omitempty"`
	TitleImages  map[string]Image `json:"titleImage"`

	CreatedAt        *Time `json:"created_at,omitempty"`
	PublishDate      *Time `json:"publishDate,omitempty"`
	ModificationDate *Time `json:"modificationDate,omitempty"`
	UpdatedAt        *Time `json:"updated_at,omitempty"`
}

type Image struct {
	Path     string `json:"path"`
	FullPath string `json:"fullPath"`

	Height uint `json:"height"`
	Width  uint `json:"width"`
}

type Comment struct {
	ID string `json:"_id"`

	Path string `json:"path"`

	AuthorID string `json:"authorId"`

	Body map[string]string `json:"body"`

	ChildrenCount uint `json:"childrenCount"`
	Level         uint `json:"level"`

	CreatedAt      *Time  `json:"created_at"`
	LastBodyUpdate *Time  `json:"lastBodyUpdate"`
	UpdatedAt      *Time  `json:"updated_at"`
	Updated        bool   `json:"updated"`
	UpdatedBy      string `json:"updatedBy"`

	IsRemoved     bool `json:"isRemoved"`
	IsYandexStaff bool `json:"isYandexStaff"`
	CanEdit       bool `json:"canEdit"`
	CanRemove     bool `json:"canRemove"`
	CanSubscribe  bool `json:"canSubscribe"`

	ReplyCount uint   `json:"replyCount"`
	ReplyTo    string `json:"replyTo"`
	ReplyToUID string `json:"replyToUid"`
}

type RelatedArticle struct {
	URL string `json:"url,omitempty"`

	Slug string `json:"slug,omitempty"`

	Title string `json:"title"`
	Image string `json:"image"`
}
